function [Y J2bar]=event_finder_cogil(rho,A1,A2,W,V,M,L,lambda)
if rho<0 || rho >1
    error('rho must be in [0,1]');
else
    setlmis([]);
    y=lmivar(1,[2,1]);
    lmiterm([1 1 1 y],(1-rho)*A1',A1);
    lmiterm([1 1 1 y],rho*A2',A2);
    lmiterm([1 1 1 y],-1,1);
    lmiterm([1 1 1 0],M);
    lmiterm([2,1,1,y],-1,1);
    lmisys=getlmis;
    R=rho*L*V*L';
    c=mat2dec(lmisys,R+W);
    [copt,xopt]=mincx(lmisys,c);
    if size(xopt)==[0 0]
        error('Increase rho.');
    else
        Y=dec2mat(lmisys,xopt,y);
        J2bar=copt+rho*lambda;
    end
end